/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWWorkObject;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWDebug;
import java.util.Date;

public class VWTrkTestDataField {
    VWDataField m_dataField = null;
    VWFieldDefinition m_definition = null;
    VWWorkObject m_workObject = null;
    String m_name = null;
    Object m_value = null;
    boolean m_bSystemField = false;
    int m_type = 0;
    int m_mergeType = 0;
    boolean m_bAltered = false;

    public VWTrkTestDataField(VWWorkObject workObject, VWDataField dataField, VWFieldDefinition definition) {
        this.m_dataField = dataField;
        this.m_definition = definition;
        this.m_workObject = workObject;
    }

    public VWTrkTestDataField(VWDataField dataField, VWFieldDefinition definition) {
        this.m_dataField = dataField;
        this.m_definition = definition;
    }

    public VWTrkTestDataField(String name, Object value) {
        Object obj = value;
        this.m_dataField = null;
        this.m_name = name;
        this.m_value = value;
        if (value.getClass().isArray()) {
            obj = ((Object[])value)[0];
        }
        if (obj instanceof Boolean) {
            this.m_type = 4;
        } else if (obj instanceof Integer) {
            this.m_type = 1;
        } else if (obj instanceof Double) {
            this.m_type = 8;
        } else if (obj instanceof Date) {
            this.m_type = 16;
        } else if (obj instanceof String) {
            this.m_type = 2;
        } else if (obj instanceof VWXMLData) {
            this.m_type = 128;
        }
    }

    public String getDescription() {
        if (this.m_definition != null) {
            return this.m_definition.getDescription();
        }
        return null;
    }

    public int getFieldType() {
        if (this.m_dataField != null) {
            this.m_type = this.m_dataField.getFieldType();
        }
        return this.m_type;
    }

    public int getMergeType() {
        if (this.m_definition != null) {
            this.m_mergeType = this.m_definition.getMergeType();
        }
        return this.m_mergeType;
    }

    public boolean getIsSystemField() {
        if (this.m_dataField != null) {
            return this.m_dataField.getIsSystemField();
        }
        return this.m_bSystemField;
    }

    public String getName() {
        if (this.m_dataField != null) {
            return this.m_dataField.getName();
        }
        return this.m_name;
    }

    public Object getValue() {
        block5: {
            try {
                if (this.m_workObject != null) {
                    return this.m_workObject.getFieldValue(this.getName());
                }
                if (this.m_dataField != null) {
                    return this.m_dataField.getValue();
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_dataField.getFieldType() != 32) break block5;
                if (this.m_dataField.isArray()) {
                    return new VWAttachment[0];
                }
                return new VWAttachment();
            }
        }
        return this.m_value;
    }

    public boolean isArray() {
        if (this.m_dataField != null) {
            return this.m_dataField.isArray();
        }
        return this.m_value.getClass().isArray();
    }

    public void setValue(Object value, boolean bCompare) throws VWException {
        if (this.m_workObject != null) {
            this.m_workObject.setFieldValue(this.getName(), value, bCompare);
        } else if (this.m_dataField != null) {
            this.m_dataField.setValue(value);
        } else {
            this.m_value = value;
            this.m_bAltered = true;
        }
    }

    public String toString() {
        if (this.m_dataField != null) {
            return this.m_dataField.toString();
        }
        return this.m_value.toString();
    }

    public boolean isAltered() {
        return this.m_bAltered;
    }

    public void removeReferences() {
        this.m_dataField = null;
        this.m_definition = null;
        this.m_workObject = null;
        this.m_name = null;
        this.m_value = null;
    }
}

